<?php

namespace App\Http\Controllers;

use App\Models\Author;
use App\Models\Token;
use App\Models\User;
use App\Services\BootstrapTableService;
use App\Services\ResponseService;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AuthorController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // ResponseService::noAnyPermissionThenRedirect(['author-list', 'author-create', 'author-edit', 'author-delete']);
        return view('author.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request, string $id)
    {
        //
        // ResponseService::noPermissionThenRedirect('author-list');
        $offset = $request->input('offset', 0);
        $limit = $request->input('limit', 10);
        $sort = $request->input('sort', 'id');
        $order = $request->input('order', 'DESC');

        $sql = Author::orderBy($sort, $order);

        $sql = $sql->with('user');
        if (!empty($request->search)) {
            $sql = $sql->search($request->search);
        }
        $total = $sql->count();
        $sql = $sql->skip($offset)->take($limit);

        $result = $sql->get();
        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $no = 1;
        foreach ($result as $row) {
            $tempRow = $row->toArray();
            $tempRow['no'] = $no++;
            $tempRow['user_name'] = $row->user->name;

            $operate = '';
            // if (Auth::user()->can('author-edit')) {
                $operate .= BootstrapTableService::editButton(
                    route('author.update', $row->id),
                    true, // modal
                    '#editDataModal', // data-target
                    null,
                    null, // id
                    'fa fa-edit', // iconClass
                    null, // onClick
                    $row->id, // dataId
                    // $row->user_id // data-user-id
                );
            // }
            // if (Auth::user()->can('project-delete')) {
            //     $temp['operate'] .= BootstrapTableService::deleteButton(route('project.destroy', $row->id));
            // }

            // status change button


            $tempRow['operate'] = $operate;
            $rows[] = $tempRow;
        }



        $bulkData['rows'] = $rows;
        return response()->json($bulkData);

    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {

        // try {

            $validator = Validator::make($request->all(), [
                'author_status' => 'required|in:pending,approved,rejected',
            ]);

            if ($validator->fails()) {
                    return ResponseService::validationError($validator->errors()->first());
            }

            $author = Author::findOrFail($id);
            $author->status = $request->author_status;
            $author->save();

            if($request->author_status == 'approved'){
                $user = User::findOrFail($author->user_id);
                $user->is_author = 1;
                $user->save();

                $tokens = Token::where('token', $user->fcm_id)->first();


                // notification
                if($tokens->language_id){

                    $fcmMsg = [
                        'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                        'message' => 'Your author request has been approved',
                        'body' => 'Your author request has been approved',
                        'author_id' => $id,
                        'language_id' => $tokens->language_id ?? 1,
                        'type' => 'author_approved',
                    ];
                    send_notification($fcmMsg, 1, 0, [$tokens->token]);
                }
                return ResponseService::successResponse(__('author_status_updated.'));
            }elseif($request->author_status == 'rejected'){

                $user = User::findOrFail($author->user_id);
                $user->is_author = 0;
                $user->save();
            }

            return ResponseService::successResponse(__('author_status_updated.'));

        // } catch (Exception $e) {
        //     ResponseService::logErrorResponse($e, "AuthorController -> update");
        //     return ResponseService::errorResponse(__('Something Went Wrong'));
        // }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
