<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Author extends Model
{
    use HasFactory;

    protected $table = 'tbl_authors';

    protected $fillable = [
        'user_id',
        'bio',
        'telegram_link',
        'linkedin_link',
        'facebook_link',
        'whatsapp_link',
        'status'
    ];

    protected $hidden = [
        'updated_at',
        'created_at'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function news()
    {
        return $this->hasMany(News::class, 'user_id', 'user_id');
    }
}
